document.addEventListener('DOMContentLoaded', () => {
  const urlInput = document.getElementById('webhookUrl');
  const saveBtn = document.getElementById('saveBtn');
  const statusDiv = document.getElementById('status');

  // 从 storage 读取已保存的 URL
  chrome.storage.sync.get(['webhookUrl'], (result) => {
    if (result.webhookUrl) {
      urlInput.value = result.webhookUrl;
    }
  });

  saveBtn.addEventListener('click', () => {
    const url = urlInput.value.trim();
    if (!url) {
      showStatus('URL 不能为空', 'error');
      return;
    }

    try {
      new URL(url); // 验证是否为合法 URL
    } catch (e) {
      showStatus('请输入有效的 URL', 'error');
      return;
    }

    if (!url.includes('qyapi.weixin.qq.com') || !url.includes('/webhook/send')) {
      showStatus('URL 应为企业微信机器人地址', 'error');
      return;
    }

    chrome.storage.sync.set({ webhookUrl: url }, () => {
      showStatus('✅ 保存成功！', 'success');
    });
  });

  function showStatus(text, type) {
    statusDiv.textContent = text;
    statusDiv.className = 'status ' + type;
  }
});